<?php
header("Content-Type: application/json");

require 'db.php'; // Ensure this connects correctly to your database

// Read and decode JSON input
$data = json_decode(file_get_contents("php://input"), true);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

if (!$data) {
    echo json_encode(["status" => "error", "message" => "Invalid or missing JSON payload"]);
    exit;
}

// Sanitize input
$couponcode = mysqli_real_escape_string($conn, $data['couponcode']);
$createddate = date('Y-m-d'); 
$expiryDate = mysqli_real_escape_string($conn, $data['expirydate']);
$description = mysqli_real_escape_string($conn, $data['description']);
$usagepercustomer = mysqli_real_escape_string($conn, $data['percustomer']);
$productid = mysqli_real_escape_string($conn, $data['productid']);
$customerid = mysqli_real_escape_string($conn, $data['customerid']);
$amount = mysqli_real_escape_string($conn, $data['amount'] ?? '0');
$percentage = mysqli_real_escape_string($conn, $data['percentage'] ?? '0');
$autoapply = mysqli_real_escape_string($conn, $data['autoapply']);
$minorderamount = mysqli_real_escape_string($conn, $data['minorderamount']);
$maxdiscount = mysqli_real_escape_string($conn , $data['maxdiscount']);
$showthiscoupon = mysqli_real_escape_string($conn, $data['showthiscoupon']);
$newcustomer = mysqli_real_escape_string($conn, $data['newcustomer']);

// Insert into coupon table
$sql_coupon = "INSERT INTO coupon (
    coupon_code, description, created_date, expiry_date, usage_per_customer, product_id, customer_id, percentage, amount, auto_apply, min_order_amount,maxamount,showthiscoupon,newcustomer
) VALUES (
    '$couponcode', '$description', '$createddate', '$expiryDate', '$usagepercustomer', '$productid', '$customerid', '$percentage', '$amount', '$autoapply', '$minorderamount','$maxdiscount','$showthiscoupon','$newcustomer'
)";

if (mysqli_query($conn, $sql_coupon)) {
    echo json_encode(["status" => "success"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to insert coupon data", "error_detail" => mysqli_error($conn)]);
}

mysqli_close($conn);
?>